'********************************************************************************
'
'                       C O P Y R I G H T  (c) 2002
'                 S O F T W A R E   T O O L B O X   I N C.
'                           All Rights Reserved.
'   ........................................................................
'   This sample code is provided by Software Toolbox solely to assist in
'   understanding the use of the SLIK-DA ActiveX Control. This code is
'   provided as-is and without warranty or support of any sort.
'
'********************************************************************************
'
'   Project:        SLIK-DA ActiveX Control
'
'   Description:    This sample server application is based on Software Toolbox's
'                   Simple Language Independent Toolkit for creating OPC
'                   Data Access servers (SLIK-DA). This implementation illustrates
'                   the use of various features of the SLIK-DA ActiveX Control.
'
'   Revision:
'       02-03-27    gmg     Initial release.
'
'********************************************************************************

Option Strict Off
Option Explicit On
Imports VB = Microsoft.VisualBasic
Imports SLIKDA = NDI.SLIKDA.Interop

Friend Class frmMain
    Inherits System.Windows.Forms.Form
#Region "Windows Form Designer generated code "
    Public Sub New()
        MyBase.New()
        'This call is required by the Windows Form Designer.
        InitializeComponent()
    End Sub
    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal Disposing As Boolean)
        If Disposing Then
            If Not components Is Nothing Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(Disposing)
    End Sub
    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer
    Public ToolTip1 As System.Windows.Forms.ToolTip
    Public WithEvents tmrTagUpdate As System.Windows.Forms.Timer
    Public WithEvents tmrMain As System.Windows.Forms.Timer
    Public WithEvents mnuFileClientDisc As System.Windows.Forms.MenuItem
    Public WithEvents mnuFileSep1 As System.Windows.Forms.MenuItem
    Public WithEvents mnuFileForceExit As System.Windows.Forms.MenuItem
    Public WithEvents mnuFileSep2 As System.Windows.Forms.MenuItem
    Public WithEvents mnuFileExit As System.Windows.Forms.MenuItem
    Public WithEvents mnuFile As System.Windows.Forms.MenuItem
    Public WithEvents mnuEditStatPeriod As System.Windows.Forms.MenuItem
    Public WithEvents mnuEdit As System.Windows.Forms.MenuItem
    Public WithEvents mnuTraceNone As System.Windows.Forms.MenuItem
    Public WithEvents mnuTraceConnect As System.Windows.Forms.MenuItem
    Public WithEvents mnuTraceGroup As System.Windows.Forms.MenuItem
    Public WithEvents mnuTraceItem As System.Windows.Forms.MenuItem
    Public WithEvents mnuTraceAll As System.Windows.Forms.MenuItem
    Public WithEvents mnuTraceSep1 As System.Windows.Forms.MenuItem
    Public WithEvents mnuTraceClear As System.Windows.Forms.MenuItem
    Public WithEvents mnuTraceSep2 As System.Windows.Forms.MenuItem
    Public WithEvents mnuTraceCOM As System.Windows.Forms.MenuItem
    Public WithEvents mnuTrace As System.Windows.Forms.MenuItem
    Public WithEvents mnuHelpAbout As System.Windows.Forms.MenuItem
    Public WithEvents mnuHelp As System.Windows.Forms.MenuItem
    Public MainMenu1 As System.Windows.Forms.MainMenu
    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.
    'Do not modify it using the code editor.
    Public WithEvents tabMain As System.Windows.Forms.TabControl
    Public WithEvents _tabMain_TabPage0 As System.Windows.Forms.TabPage
    Friend WithEvents lvStats As AxMSComctlLib.AxListView
    Public WithEvents _tabMain_TabPage1 As System.Windows.Forms.TabPage
    Public WithEvents txtTraceMsgs As System.Windows.Forms.TextBox
    Public WithEvents fraDescription As System.Windows.Forms.GroupBox
    Public WithEvents imgCert As System.Windows.Forms.PictureBox
    Public WithEvents lblDescription As System.Windows.Forms.Label
    Friend WithEvents mnuSec As System.Windows.Forms.MenuItem
    Friend WithEvents SlikServer1 As NDI.SLIKDA.Interop.SLIKServer
    Friend WithEvents mnuSecPriv As System.Windows.Forms.MenuItem
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Dim resources As System.ComponentModel.ComponentResourceManager = New System.ComponentModel.ComponentResourceManager(GetType(frmMain))
        Me.ToolTip1 = New System.Windows.Forms.ToolTip(Me.components)
        Me.tmrTagUpdate = New System.Windows.Forms.Timer(Me.components)
        Me.tmrMain = New System.Windows.Forms.Timer(Me.components)
        Me.MainMenu1 = New System.Windows.Forms.MainMenu(Me.components)
        Me.mnuFile = New System.Windows.Forms.MenuItem
        Me.mnuFileClientDisc = New System.Windows.Forms.MenuItem
        Me.mnuFileSep1 = New System.Windows.Forms.MenuItem
        Me.mnuFileForceExit = New System.Windows.Forms.MenuItem
        Me.mnuFileSep2 = New System.Windows.Forms.MenuItem
        Me.mnuFileExit = New System.Windows.Forms.MenuItem
        Me.mnuEdit = New System.Windows.Forms.MenuItem
        Me.mnuEditStatPeriod = New System.Windows.Forms.MenuItem
        Me.mnuTrace = New System.Windows.Forms.MenuItem
        Me.mnuTraceNone = New System.Windows.Forms.MenuItem
        Me.mnuTraceConnect = New System.Windows.Forms.MenuItem
        Me.mnuTraceGroup = New System.Windows.Forms.MenuItem
        Me.mnuTraceItem = New System.Windows.Forms.MenuItem
        Me.mnuTraceAll = New System.Windows.Forms.MenuItem
        Me.mnuTraceSep1 = New System.Windows.Forms.MenuItem
        Me.mnuTraceClear = New System.Windows.Forms.MenuItem
        Me.mnuTraceSep2 = New System.Windows.Forms.MenuItem
        Me.mnuTraceCOM = New System.Windows.Forms.MenuItem
        Me.mnuSec = New System.Windows.Forms.MenuItem
        Me.mnuSecPriv = New System.Windows.Forms.MenuItem
        Me.mnuHelp = New System.Windows.Forms.MenuItem
        Me.mnuHelpAbout = New System.Windows.Forms.MenuItem
        Me.tabMain = New System.Windows.Forms.TabControl
        Me._tabMain_TabPage0 = New System.Windows.Forms.TabPage
        Me.lvStats = New AxMSComctlLib.AxListView
        Me._tabMain_TabPage1 = New System.Windows.Forms.TabPage
        Me.txtTraceMsgs = New System.Windows.Forms.TextBox
        Me.fraDescription = New System.Windows.Forms.GroupBox
        Me.SlikServer1 = New NDI.SLIKDA.Interop.SLIKServer
        Me.imgCert = New System.Windows.Forms.PictureBox
        Me.lblDescription = New System.Windows.Forms.Label
        Me.tabMain.SuspendLayout()
        Me._tabMain_TabPage0.SuspendLayout()
        CType(Me.lvStats, System.ComponentModel.ISupportInitialize).BeginInit()
        Me._tabMain_TabPage1.SuspendLayout()
        Me.fraDescription.SuspendLayout()
        CType(Me.SlikServer1, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.imgCert, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'tmrTagUpdate
        '
        Me.tmrTagUpdate.Enabled = True
        Me.tmrTagUpdate.Interval = 1000
        '
        'tmrMain
        '
        Me.tmrMain.Interval = 1000
        '
        'MainMenu1
        '
        Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile, Me.mnuEdit, Me.mnuTrace, Me.mnuSec, Me.mnuHelp})
        '
        'mnuFile
        '
        Me.mnuFile.Index = 0
        Me.mnuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFileClientDisc, Me.mnuFileSep1, Me.mnuFileForceExit, Me.mnuFileSep2, Me.mnuFileExit})
        Me.mnuFile.Text = "&File"
        '
        'mnuFileClientDisc
        '
        Me.mnuFileClientDisc.Index = 0
        Me.mnuFileClientDisc.Text = "&Request Clients To Disconnect"
        '
        'mnuFileSep1
        '
        Me.mnuFileSep1.Index = 1
        Me.mnuFileSep1.Text = "-"
        '
        'mnuFileForceExit
        '
        Me.mnuFileForceExit.Index = 2
        Me.mnuFileForceExit.Text = "&Force Server Exit"
        '
        'mnuFileSep2
        '
        Me.mnuFileSep2.Index = 3
        Me.mnuFileSep2.Text = "-"
        '
        'mnuFileExit
        '
        Me.mnuFileExit.Index = 4
        Me.mnuFileExit.Text = "E&xit"
        '
        'mnuEdit
        '
        Me.mnuEdit.Index = 1
        Me.mnuEdit.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuEditStatPeriod})
        Me.mnuEdit.Text = "&Edit"
        '
        'mnuEditStatPeriod
        '
        Me.mnuEditStatPeriod.Index = 0
        Me.mnuEditStatPeriod.Text = "Statistics Sample &Period ..."
        '
        'mnuTrace
        '
        Me.mnuTrace.Index = 2
        Me.mnuTrace.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuTraceNone, Me.mnuTraceConnect, Me.mnuTraceGroup, Me.mnuTraceItem, Me.mnuTraceAll, Me.mnuTraceSep1, Me.mnuTraceClear, Me.mnuTraceSep2, Me.mnuTraceCOM})
        Me.mnuTrace.Text = "&Trace"
        '
        'mnuTraceNone
        '
        Me.mnuTraceNone.Checked = True
        Me.mnuTraceNone.Index = 0
        Me.mnuTraceNone.Text = "&None"
        '
        'mnuTraceConnect
        '
        Me.mnuTraceConnect.Index = 1
        Me.mnuTraceConnect.Text = "&Connect"
        '
        'mnuTraceGroup
        '
        Me.mnuTraceGroup.Index = 2
        Me.mnuTraceGroup.Text = "&Group"
        '
        'mnuTraceItem
        '
        Me.mnuTraceItem.Index = 3
        Me.mnuTraceItem.Text = "&Item"
        '
        'mnuTraceAll
        '
        Me.mnuTraceAll.Index = 4
        Me.mnuTraceAll.Text = "&All"
        '
        'mnuTraceSep1
        '
        Me.mnuTraceSep1.Index = 5
        Me.mnuTraceSep1.Text = "-"
        '
        'mnuTraceClear
        '
        Me.mnuTraceClear.Index = 6
        Me.mnuTraceClear.Text = "C&lear Messages"
        '
        'mnuTraceSep2
        '
        Me.mnuTraceSep2.Index = 7
        Me.mnuTraceSep2.Text = "-"
        '
        'mnuTraceCOM
        '
        Me.mnuTraceCOM.Index = 8
        Me.mnuTraceCOM.Text = "&Enable COM Call Tracing"
        '
        'mnuSec
        '
        Me.mnuSec.Index = 3
        Me.mnuSec.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuSecPriv})
        Me.mnuSec.Text = "&Security"
        '
        'mnuSecPriv
        '
        Me.mnuSecPriv.Index = 0
        Me.mnuSecPriv.Text = "Enable Private"
        '
        'mnuHelp
        '
        Me.mnuHelp.Index = 4
        Me.mnuHelp.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuHelpAbout})
        Me.mnuHelp.Text = "&Help"
        '
        'mnuHelpAbout
        '
        Me.mnuHelpAbout.Index = 0
        Me.mnuHelpAbout.Text = "&About ..."
        '
        'tabMain
        '
        Me.tabMain.Controls.Add(Me._tabMain_TabPage0)
        Me.tabMain.Controls.Add(Me._tabMain_TabPage1)
        Me.tabMain.Dock = System.Windows.Forms.DockStyle.Top
        Me.tabMain.Font = New System.Drawing.Font("Arial", 8.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.tabMain.ItemSize = New System.Drawing.Size(42, 18)
        Me.tabMain.Location = New System.Drawing.Point(0, 0)
        Me.tabMain.Name = "tabMain"
        Me.tabMain.SelectedIndex = 0
        Me.tabMain.Size = New System.Drawing.Size(592, 240)
        Me.tabMain.TabIndex = 3
        '
        '_tabMain_TabPage0
        '
        Me._tabMain_TabPage0.Controls.Add(Me.lvStats)
        Me._tabMain_TabPage0.Location = New System.Drawing.Point(4, 22)
        Me._tabMain_TabPage0.Name = "_tabMain_TabPage0"
        Me._tabMain_TabPage0.Size = New System.Drawing.Size(584, 214)
        Me._tabMain_TabPage0.TabIndex = 0
        Me._tabMain_TabPage0.Text = "Statistics"
        '
        'lvStats
        '
        Me.lvStats.Dock = System.Windows.Forms.DockStyle.Fill
        Me.lvStats.Location = New System.Drawing.Point(0, 0)
        Me.lvStats.Name = "lvStats"
        Me.lvStats.OcxState = CType(resources.GetObject("lvStats.OcxState"), System.Windows.Forms.AxHost.State)
        Me.lvStats.Size = New System.Drawing.Size(584, 214)
        Me.lvStats.TabIndex = 3
        '
        '_tabMain_TabPage1
        '
        Me._tabMain_TabPage1.Controls.Add(Me.txtTraceMsgs)
        Me._tabMain_TabPage1.Location = New System.Drawing.Point(4, 22)
        Me._tabMain_TabPage1.Name = "_tabMain_TabPage1"
        Me._tabMain_TabPage1.Size = New System.Drawing.Size(584, 214)
        Me._tabMain_TabPage1.TabIndex = 1
        Me._tabMain_TabPage1.Text = "Trace Messages"
        Me._tabMain_TabPage1.Visible = False
        '
        'txtTraceMsgs
        '
        Me.txtTraceMsgs.AcceptsReturn = True
        Me.txtTraceMsgs.BackColor = System.Drawing.SystemColors.Window
        Me.txtTraceMsgs.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.txtTraceMsgs.Dock = System.Windows.Forms.DockStyle.Fill
        Me.txtTraceMsgs.Font = New System.Drawing.Font("Arial", 8.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.txtTraceMsgs.ForeColor = System.Drawing.SystemColors.WindowText
        Me.txtTraceMsgs.Location = New System.Drawing.Point(0, 0)
        Me.txtTraceMsgs.MaxLength = 0
        Me.txtTraceMsgs.Multiline = True
        Me.txtTraceMsgs.Name = "txtTraceMsgs"
        Me.txtTraceMsgs.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.txtTraceMsgs.ScrollBars = System.Windows.Forms.ScrollBars.Both
        Me.txtTraceMsgs.Size = New System.Drawing.Size(584, 214)
        Me.txtTraceMsgs.TabIndex = 4
        '
        'fraDescription
        '
        Me.fraDescription.BackColor = System.Drawing.SystemColors.Control
        Me.fraDescription.Controls.Add(Me.SlikServer1)
        Me.fraDescription.Controls.Add(Me.imgCert)
        Me.fraDescription.Controls.Add(Me.lblDescription)
        Me.fraDescription.Dock = System.Windows.Forms.DockStyle.Bottom
        Me.fraDescription.Font = New System.Drawing.Font("Arial", 8.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.fraDescription.ForeColor = System.Drawing.SystemColors.ControlText
        Me.fraDescription.Location = New System.Drawing.Point(0, 226)
        Me.fraDescription.Name = "fraDescription"
        Me.fraDescription.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.fraDescription.Size = New System.Drawing.Size(592, 83)
        Me.fraDescription.TabIndex = 7
        Me.fraDescription.TabStop = False
        '
        'SlikServer1
        '
        Me.SlikServer1.Enabled = True
        Me.SlikServer1.Location = New System.Drawing.Point(426, 37)
        Me.SlikServer1.Name = "SlikServer1"
        Me.SlikServer1.OcxState = CType(resources.GetObject("SlikServer1.OcxState"), System.Windows.Forms.AxHost.State)
        Me.SlikServer1.Size = New System.Drawing.Size(32, 32)
        Me.SlikServer1.TabIndex = 3
        '
        'imgCert
        '
        Me.imgCert.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.imgCert.Cursor = System.Windows.Forms.Cursors.Default
        Me.imgCert.Image = CType(resources.GetObject("imgCert.Image"), System.Drawing.Image)
        Me.imgCert.Location = New System.Drawing.Point(480, 9)
        Me.imgCert.Name = "imgCert"
        Me.imgCert.Size = New System.Drawing.Size(104, 70)
        Me.imgCert.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
        Me.imgCert.TabIndex = 1
        Me.imgCert.TabStop = False
        '
        'lblDescription
        '
        Me.lblDescription.BackColor = System.Drawing.SystemColors.Control
        Me.lblDescription.Cursor = System.Windows.Forms.Cursors.Default
        Me.lblDescription.Font = New System.Drawing.Font("Arial", 8.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblDescription.ForeColor = System.Drawing.SystemColors.ControlText
        Me.lblDescription.Location = New System.Drawing.Point(6, 16)
        Me.lblDescription.Name = "lblDescription"
        Me.lblDescription.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.lblDescription.Size = New System.Drawing.Size(474, 65)
        Me.lblDescription.TabIndex = 2
        Me.lblDescription.Text = resources.GetString("lblDescription.Text")
        '
        'frmMain
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(592, 309)
        Me.Controls.Add(Me.fraDescription)
        Me.Controls.Add(Me.tabMain)
        Me.Font = New System.Drawing.Font("Arial", 8.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Menu = Me.MainMenu1
        Me.Name = "frmMain"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.Manual
        Me.Text = "VB .NET Advanced OPC Server"
        Me.tabMain.ResumeLayout(False)
        Me._tabMain_TabPage0.ResumeLayout(False)
        CType(Me.lvStats, System.ComponentModel.ISupportInitialize).EndInit()
        Me._tabMain_TabPage1.ResumeLayout(False)
        Me._tabMain_TabPage1.PerformLayout()
        Me.fraDescription.ResumeLayout(False)
        CType(Me.SlikServer1, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.imgCert, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

    Public Shared Sub Main()
        'Throws an exception if Close() is called in Load
        'i.e. /regserver or /unregserver is specified
        Try
            Application.Run(New frmMain)
        Catch
        End Try
    End Sub
#End Region

    Public m_sAppName As String

    ' Maximum size (in characters) of all messages in the Trace Window.
    Private Const c_nMaxTraceViewLen As Integer = 30000

    ' Flag indicating message destination for ReportEvent method. Set this flag as
    ' follows:
    '   True - Display message in popup dialog.
    '   False - Log message to trace window. Use this setting to prevent popup dialogs
    '       when running the server in the background.
    Private Const c_bUseMsgBox As Boolean = False

    ' Flag indicating whether the 'Force Server Exit' option has been selected
    Private m_bForceExit As Boolean

    ' Define a simple security database.  A real server
    Private Structure SecDBType
        Public UserName As String
        Public Password As String
        Public AccessGranted As Long
    End Structure
    Private m_SecDB(3) As SecDBType


    '********************************************************************************
    ' Description:      Log a debug message to the trace window.
    '
    ' Parameters:
    '   In:             sMsg  The debug message.
    '   Out:            None
    '
    ' Return Value:     None
    '********************************************************************************
    Private Sub LogDebugMessage(ByRef sMsg As String)
        Call LogTraceMessage("DEBUG (" & sMsg & ")")
    End Sub

    '********************************************************************************
    ' Description:      Log a message to the trace window.
    '
    ' Parameters:
    '   In:             sMsg  The trace message.
    '   Out:            None
    '
    ' Return Value:     None
    '********************************************************************************
    Private Sub LogTraceMessage(ByRef sMsg As String)

        '
        ' Format the message for the trace window.
        '
        Dim sTemp As String
        sTemp = VB6.Format(Now, "hh:mm:ss") & " " & sMsg & vbNewLine

        Dim nPos As Integer
        If (Len(txtTraceMsgs.Text) > c_nMaxTraceViewLen) Then
            '
            '  Make room for more messages
            '
            nPos = InStr(c_nMaxTraceViewLen * 0.25, txtTraceMsgs.Text, vbNewLine, CompareMethod.Text)
            If nPos > 0 Then
                txtTraceMsgs.Text = Mid(txtTraceMsgs.Text, nPos + 2)
            End If
        End If

        '
        ' Append message in the trace window
        '
        txtTraceMsgs.SelectionStart = Len(txtTraceMsgs.Text)
        txtTraceMsgs.SelectedText = sTemp

    End Sub

    '********************************************************************************
    ' Description:      Either display a message box for the given message, or log the
    '                   message to the trace window.
    '
    ' Parameters:
    '   In:             sMsg  The trace message.
    '   Out:            None
    '
    ' Return Value:     None
    '********************************************************************************
    Public Sub ReportEvent(ByRef sPrompt As String, ByRef sTitle As String)

        If c_bUseMsgBox Then
            Call MsgBox(sPrompt, MsgBoxStyle.OkOnly, sTitle)
        Else
            Call LogDebugMessage(sTitle & ": " & sPrompt)
        End If

    End Sub


    '********************************************************************************
    ' Description:      Initialize the statistics window with the list of server
    '                   statistics. Create a entry (row) for each statistic.
    '
    ' Parameters:
    '   In:             None
    '   Out:            None
    '
    ' Return Value:     None
    '********************************************************************************
    Private Sub InitializeStatsView()

        lvStats.ListItems.Add(c_nStatSamplePeriod, , "Sample Period (ms)")
        lvStats.ListItems.Add(c_nStatClients, , "Number of Clients")
        lvStats.ListItems.Add(c_nStatGroups, , "Number of Groups")
        lvStats.ListItems.Add(c_nStatItems, , "Number of Items")
        lvStats.ListItems.Add(c_nStatReads, , "Number of Reads (last sample period)")
        lvStats.ListItems.Add(c_nStatWrites, , "Number of Writes (last sample period)")
        lvStats.ListItems.Add(c_nStatChanges, , "Number of Change Notifications (last sample period)")
        lvStats.ListItems.Add(c_nStatLogons, , "Number of Users Logged On")

        Call UpdateStatsView()

    End Sub

    '********************************************************************************
    ' Description:      Update the statistics window with the current value of each
    '                   server statistic.
    '
    ' Parameters:
    '   In:             None
    '   Out:            None
    '
    ' Return Value:     None
    '********************************************************************************
    Private Sub UpdateStatsView()

        On Error GoTo errHandler

        Dim Stats As SLIKDA.ISLIKStatistics
        Stats = SlikServer1.SLIKStatistics

        '
        ' Note: Use either numeric or string constants (see module mdlSLIK) to
        ' reference each statistic.
        '
        lvStats.ListItems(c_nStatSamplePeriod).SubItems(1) = Stats.Item(SLIKDA.StatsIndexEnum.sdaSamplePeriod)
        lvStats.ListItems(c_nStatClients).SubItems(1) = Stats.Item(SLIKDA.StatsIndexEnum.sdaNumClients)
        lvStats.ListItems(c_nStatGroups).SubItems(1) = Stats.Item(SLIKDA.StatsIndexEnum.sdaNumGroups)
        lvStats.ListItems(c_nStatItems).SubItems(1) = Stats.Item(SLIKDA.StatsIndexEnum.sdaNumItems)
        lvStats.ListItems(c_nStatReads).SubItems(1) = Stats.Item(SLIKDA.StatsIndexEnum.sdaNumReadsPerPeriod)
        lvStats.ListItems(c_nStatWrites).SubItems(1) = Stats.Item(SLIKDA.StatsIndexEnum.sdaNumWritesPerPeriod)
        lvStats.ListItems(c_nStatChanges).SubItems(1) = Stats.Item(SLIKDA.StatsIndexEnum.sdaNumChgPerPeriod)
        lvStats.ListItems(c_nStatLogons).SubItems(1) = Stats.Item(SLIKDA.StatsIndexEnum.sdaNumLogons)

        ' Alternative method:
        'Dim nIndex As Integer
        'nIndex = 1
        'Dim varStat As Variant
        'For Each varStat In Stats
        '    lvStats.ListItems(nIndex).SubItems(1) = varStat
        '    nIndex = nIndex + 1
        'Next varStat

        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "Update Statistics View Error")

    End Sub

    '********************************************************************************
    ' Description:      Update the main menu tracing options, so that only one option
    '                   is selected (checked).
    '
    ' Parameters:
    '   In:             TraceLevel  The user-selected trace level.
    '   Out:            None
    '
    ' Return Value:     None
    '********************************************************************************
    Private Sub UpdateTraceOptions(ByVal TraceLevel As SLIKDA.TraceLevelEnum)

        mnuTraceNone.Checked = False
        mnuTraceConnect.Checked = False
        mnuTraceGroup.Checked = False
        mnuTraceItem.Checked = False
        mnuTraceAll.Checked = False

        If TraceLevel = SLIKDA.TraceLevelEnum.sdaTraceLevelNone Then
            mnuTraceNone.Checked = True
        ElseIf TraceLevel = SLIKDA.TraceLevelEnum.sdaTraceLevelConnect Then
            mnuTraceConnect.Checked = True
        ElseIf TraceLevel = SLIKDA.TraceLevelEnum.sdaTraceLevelGroup Then
            mnuTraceGroup.Checked = True
        ElseIf TraceLevel = SLIKDA.TraceLevelEnum.sdaTraceLevelItem Then
            mnuTraceItem.Checked = True
        ElseIf TraceLevel = SLIKDA.TraceLevelEnum.sdaTraceLevelAll Then
            mnuTraceAll.Checked = True
        End If

        Call SaveSetting(m_sAppName, "Settings", "TraceLevel", SlikServer1.TraceLevel)

    End Sub

    '********************************************************************************
    ' Description:      Initialize the application.
    '********************************************************************************
    Private Sub frmMain_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load

        Dim bExit As Boolean
        bExit = False

        On Error GoTo errHandler

        m_bForceExit = False

        '
        ' Initialize the main form properties.
        '
        m_sAppName = "Software Toolbox's " & Me.Text
        Me.Left = GetSetting(m_sAppName, "Settings", "MainLeft", 0)
        Me.Top = GetSetting(m_sAppName, "Settings", "MainTop", 0)
        Me.Width = GetSetting(m_sAppName, "Settings", "MainWidth", 400)
        Me.Height = GetSetting(m_sAppName, "Settings", "MainHeight", 300)

        Dim nTab As Integer
        nTab = CInt(GetSetting(m_sAppName, "Settings", "TabSelected", CStr(0)))
        If nTab >= tabMain.TabPages.Count() Then
            nTab = tabMain.TabPages.Count() - 1
        ElseIf nTab < 0 Then
            nTab = 0
        End If
        tabMain.SelectedIndex = nTab

        ' Get the command line arguments to check for server registration switches
        Dim sCmdLine As String
        sCmdLine = VB.Command()

        '
        ' NOTE: Do NOT prefix server registration switches with a forward slash "/".
        ' The VB runtime engine with NOT pass such arguments to the application.
        '
        'Call LogDebugMessage("Command line arguments: '" & sCmdLine & "'")

        '
        ' Perform server registration as required.
        '
        If InStr(1, sCmdLine, "unregserver", CompareMethod.Text) > 0 Then
            SlikServer1.UnregisterServer()
            bExit = True
        ElseIf InStr(1, sCmdLine, "regserver", CompareMethod.Text) > 0 Then
            SlikServer1.RegisterServer()
            bExit = True
        Else
            ' ignore any other switches
        End If

        If bExit Then
            ' If a server registration switch was specified in the command line, the
            ' standard COM server behaviour is to exit immediately after changing the
            ' registration information.
            m_bForceExit = True
            Me.Close()
            Exit Sub
        End If

        '
        ' Initialize the security database
        '
        Dim i As Integer
        For i = 0 To 2
            m_SecDB(i).UserName = "User" + CStr(i + 1)
            m_SecDB(i).Password = "pw" + CStr(i + 1)
            If i = 0 Then
                m_SecDB(i).AccessGranted = SLIKDA.AccessGrantedEnum.sdaAGItemRead + SLIKDA.AccessGrantedEnum.sdaAGItemWrite
            ElseIf i = 1 Then
                m_SecDB(i).AccessGranted = SLIKDA.AccessGrantedEnum.sdaAGItemRead
            ElseIf i = 2 Then
                m_SecDB(i).AccessGranted = SLIKDA.AccessGrantedEnum.sdaAGItemWrite
            End If
        Next i

        '
        ' Start the server with the pre-defined namespace
        '
        If Not InitNamespace(SlikServer1, Me) Then
            m_bForceExit = True
            Me.Close()
            Exit Sub
        End If
        SlikServer1.StartServer()

        '
        ' Initialize the statistics tab.
        '
        Call InitializeStatsView()

        ' Start the periodic update of the statistics window.
        tmrMain.Enabled = True

        '
        ' Initialize the trace message logging.
        ' NOTE: For this sample application, always log trace message to the trace window.
        '
        Dim eTraceLevel As SLIKDA.TraceLevelEnum
        eTraceLevel = CShort(GetSetting(m_sAppName, "Settings", "TraceLevel", CStr(SLIKDA.TraceLevelEnum.sdaTraceLevelNone)))
        SlikServer1.SetTraceInfo(eTraceLevel, SLIKDA.TraceDestEnum.sdaTraceToEvent)
        Call UpdateTraceOptions(eTraceLevel)

        Call LogDebugMessage("Server initialization completed.")

        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "Startup Error")
        m_bForceExit = True
        Me.Close()
        Exit Sub

    End Sub

    '********************************************************************************
    ' Description:      Ensure that one of the following is true before exiting:
    '                   1) No client connections to this server exist
    '                   2) The user has selected the "Force Server Exit" option
    '
    ' Parameters:
    '   In:             UnloadMode  cause of the QueryUnload event
    '   Out:            Cancel      if non-zero, do NOT proceed with exit
    '
    ' Return Value:     None
    '********************************************************************************
    Private Sub frmMain_Closing(ByVal eventSender As System.Object, ByVal eventArgs As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
        Dim Cancel As Short = eventArgs.Cancel

        Dim sMsg As String
        If (SlikServer1.InUse) And (Not m_bForceExit) Then
            ' Cancel the shutdown
            Cancel = 1

            sMsg = "The server is unable to shutdown at this time. " & "There are still clients connected. " & "If required, use the 'Force Server Exit' option."
            Call ReportEvent(sMsg, Me.Text)
        End If

        ' Stop the periodic update of the statistics window.
        tmrMain.Enabled = Not Cancel

        ' NOTE: When the SLIK server object goes out of scope, it will clean up any remaining
        ' connections, groups, and items.

        eventArgs.Cancel = Cancel
    End Sub

    Private Sub frmMain_Closed(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Closed
        If Me.WindowState <> FormWindowState.Minimized Then
            SaveSetting(m_sAppName, "Settings", "MainLeft", Me.Left)
            SaveSetting(m_sAppName, "Settings", "MainTop", Me.Top)
            SaveSetting(m_sAppName, "Settings", "MainWidth", Me.Width)
            SaveSetting(m_sAppName, "Settings", "MainHeight", Me.Height)
        End If

        Call SaveSetting(m_sAppName, "Settings", "TabSelected", tabMain.SelectedIndex)
    End Sub

    '********************************************************************************
    ' Description:      Update the position and size of the controls on the main form.
    '********************************************************************************
    Private Sub frmMain_Resize(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Resize

        Dim iTabCtrlHeight As Short
        Dim iTabPaneHeight As Short
        Dim iDescrLblWidth As Short

        If (WindowState = System.Windows.Forms.FormWindowState.Minimized) Then
            'do nothing - to prevent scrunching controls
        Else
            Dim ScaleLeft As Integer = Me.Left
            Dim ScaleTop As Integer = Me.Top
            tabMain.Left = VB6.TwipsToPixelsX(ScaleLeft)
            fraDescription.Left = VB6.TwipsToPixelsX(ScaleLeft)

            tabMain.Width = ClientRectangle.Width
            fraDescription.Width = ClientRectangle.Width

            imgCert.Left = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(ClientRectangle.Width) - VB6.PixelsToTwipsX(imgCert.Width) - 120)
            

            
            lvStats.Width = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(tabMain.Width) - 100)
            txtTraceMsgs.Width = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(tabMain.Width) - 100)

            iTabCtrlHeight = VB6.PixelsToTwipsY(ClientRectangle.Height) - VB6.PixelsToTwipsY(fraDescription.Height)
            If iTabCtrlHeight > 0 Then
                tabMain.Top = VB6.TwipsToPixelsY(ScaleTop)
                tabMain.Height = VB6.TwipsToPixelsY(iTabCtrlHeight)
                fraDescription.Top = VB6.TwipsToPixelsY(iTabCtrlHeight)
                iTabPaneHeight = iTabCtrlHeight - VB6.PixelsToTwipsY(tabMain.ItemSize.Height) - 120
                If iTabPaneHeight > 0 Then
                    lvStats.Height = VB6.TwipsToPixelsY(iTabPaneHeight)
                    txtTraceMsgs.Height = VB6.TwipsToPixelsY(iTabPaneHeight)
                End If
            Else
                tabMain.Height = 0
                fraDescription.Top = VB6.TwipsToPixelsY(ScaleTop)
            End If
        End If

    End Sub

    '********************************************************************************
    ' Description:      Display application and company information.
    '********************************************************************************
    Private Sub imgLogo_DoubleClick(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs)

        VB6.ShowForm(frmAbout.DefInstance, VB6.FormShowConstants.Modal, Me)

    End Sub

    '********************************************************************************
    ' Description:      Modify the sample period (in milliseconds) that the toolkit
    '                   will use while collecting time-based statistics (e.g. number
    '                   of reads per period).
    '********************************************************************************
    Public Sub mnuEditStatPeriod_Popup(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuEditStatPeriod.Popup
        mnuEditStatPeriod_Click(eventSender, eventArgs)
    End Sub
    Public Sub mnuEditStatPeriod_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuEditStatPeriod.Click

        On Error GoTo errHandler

        frmEditSP.DefInstance.m_nStatSamplePeriod = SlikServer1.StatsSamplePeriod
        VB6.ShowForm(frmEditSP.DefInstance, VB6.FormShowConstants.Modal, Me)
        SlikServer1.StatsSamplePeriod = frmEditSP.DefInstance.m_nStatSamplePeriod

        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "Statistics Period Update Error")

    End Sub

    '********************************************************************************
    ' Description:      Issues a request to all OPC clients to release all connections
    '                   to this server.
    '
    '                   NOTE: Only V2.0 compliant clients would receive this request,
    '                   as this functionality was introduced in version 2.0 of the OPC
    '                   Data Access Standard.
    '********************************************************************************
    Public Sub mnuFileClientDisc_Popup(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuFileClientDisc.Popup
        mnuFileClientDisc_Click(eventSender, eventArgs)
    End Sub

    Public Sub mnuFileClientDisc_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuFileClientDisc.Click

        On Error GoTo errHandler

        SlikServer1.RequestDisconnect(("Server shutdown in 1 minute..."))

        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "Request Disconnect Error")

    End Sub

    '********************************************************************************
    ' Description:      Exit if no clients connections to this server exist.
    '********************************************************************************
    Public Sub mnuFileExit_Popup(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuFileExit.Popup
        mnuFileExit_Click(eventSender, eventArgs)
    End Sub

    Public Sub mnuFileExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuFileExit.Click

        Me.Close()

    End Sub

    '********************************************************************************
    ' Description:      Force this server to exit, even if clients are still connected.
    '
    '                   NOTE: Use of this feature may cause unpredictable behaviour in
    '                   certain clients. Use with caution.
    '********************************************************************************
    Public Sub mnuFileForceExit_Popup(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuFileForceExit.Popup
        mnuFileForceExit_Click(eventSender, eventArgs)
    End Sub

    Public Sub mnuFileForceExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuFileForceExit.Click

        m_bForceExit = True

        Me.Close()

    End Sub

    '********************************************************************************
    ' Description:      Display application and company information.
    '********************************************************************************
    Public Sub mnuHelpAbout_Popup(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuHelpAbout.Popup
        mnuHelpAbout_Click(eventSender, eventArgs)
    End Sub

    Public Sub mnuHelpAbout_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuHelpAbout.Click

        VB6.ShowForm(frmAbout.DefInstance, VB6.FormShowConstants.Modal, Me)

    End Sub

    '********************************************************************************
    ' Description:      Log all trace message types.
    '********************************************************************************
    Public Sub mnuTraceAll_Popup(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceAll.Popup
        mnuTraceAll_Click(eventSender, eventArgs)
    End Sub

    Public Sub mnuTraceAll_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceAll.Click

        On Error GoTo errHandler

        ' update the SLIK server
        SlikServer1.SetTraceInfo(SLIKDA.TraceLevelEnum.sdaTraceLevelAll)

        ' update the main menu options
        Call UpdateTraceOptions(SLIKDA.TraceLevelEnum.sdaTraceLevelAll)

        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "Trace Level Update Error")

    End Sub

    '********************************************************************************
    ' Description:      Log trace messages associated with client connectivity and
    '                   server activation.
    '********************************************************************************
    Public Sub mnuTraceConnect_Popup(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceConnect.Popup
        mnuTraceConnect_Click(eventSender, eventArgs)
    End Sub

    Public Sub mnuTraceConnect_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceConnect.Click

        On Error GoTo errHandler

        ' update the SLIK server
        SlikServer1.SetTraceInfo(SLIKDA.TraceLevelEnum.sdaTraceLevelConnect)

        ' update the main menu options
        Call UpdateTraceOptions(SLIKDA.TraceLevelEnum.sdaTraceLevelConnect)

        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "Trace Level Update Error")

    End Sub

    '********************************************************************************
    ' Description:      Log trace messages associated with creating, deleting, or
    '                   modifying OPC groups.
    '********************************************************************************
    Public Sub mnuTraceGroup_Popup(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceGroup.Popup
        mnuTraceGroup_Click(eventSender, eventArgs)
    End Sub

    Public Sub mnuTraceGroup_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceGroup.Click

        On Error GoTo errHandler

        ' update the SLIK server
        SlikServer1.SetTraceInfo(SLIKDA.TraceLevelEnum.sdaTraceLevelGroup)

        ' update the main menu options
        Call UpdateTraceOptions(SLIKDA.TraceLevelEnum.sdaTraceLevelGroup)

        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "Trace Level Update Error")

    End Sub

    '********************************************************************************
    ' Description:      Log trace messages associated with item transactions.
    '                   For example, read, write, and subscription transactions.
    '********************************************************************************
    Public Sub mnuTraceItem_Popup(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceItem.Popup
        mnuTraceItem_Click(eventSender, eventArgs)
    End Sub

    Public Sub mnuTraceItem_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceItem.Click

        On Error GoTo errHandler

        ' update the SLIK server
        SlikServer1.SetTraceInfo(SLIKDA.TraceLevelEnum.sdaTraceLevelItem)

        ' update the main menu options
        Call UpdateTraceOptions(SLIKDA.TraceLevelEnum.sdaTraceLevelItem)

        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "Trace Level Update Error")

    End Sub

    '********************************************************************************
    ' Description:      Turn off internal SLIK server tracing.
    '********************************************************************************
    Public Sub mnuTraceNone_Popup(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceNone.Popup
        mnuTraceNone_Click(eventSender, eventArgs)
    End Sub

    Public Sub mnuTraceNone_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceNone.Click

        On Error GoTo errHandler

        ' update the SLIK server
        SlikServer1.SetTraceInfo(SLIKDA.TraceLevelEnum.sdaTraceLevelNone)
        ' update the main menu options
        Call UpdateTraceOptions(SLIKDA.TraceLevelEnum.sdaTraceLevelNone)
        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "Trace Level Update Error")

    End Sub

    '********************************************************************************
    ' Description:      Clear the contents of the trace message tab.
    '********************************************************************************
    Public Sub mnuTraceClear_Popup(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceClear.Popup
        mnuTraceClear_Click(eventSender, eventArgs)
    End Sub

    Public Sub mnuTraceClear_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceClear.Click

        txtTraceMsgs.Text = ""

    End Sub

    '********************************************************************************
    ' Description:      Toggle logging of COM trace messages.
    '********************************************************************************
    Public Sub mnuTraceCOM_Popup(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceCOM.Popup
        mnuTraceCOM_Click(eventSender, eventArgs)
    End Sub

    Public Sub mnuTraceCOM_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles mnuTraceCOM.Click

        On Error GoTo errHandler

        ' determine the new state
        mnuTraceCOM.Checked = Not mnuTraceCOM.Checked

        ' update SLIK server
        SlikServer1.COMCallTracingEnabled = mnuTraceCOM.Checked

        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "COM Trace Toggle Error")

    End Sub

    Private Sub mnuSecPriv_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuSecPriv.Click

        On Error GoTo errHandler

        ' determine the new state
        mnuSecPriv.Checked = Not mnuSecPriv.Checked

        ' update SLIK server
        SlikServer1.SecurityPrivateEnabled = mnuSecPriv.Checked

        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "OPC Private Security Enable Toggle Error")

    End Sub
    '********************************************************************************
    ' Description:	This event is fired whenever an OPC client has requested a
    '				device read for one or more tags.
    '                   
    '				NOTE: A handler should always be provided for this event!
    '
    ' Parameters:
    '   In:	sender	-	the SLIKServer object that fired the event
    '			eventArgs -	an System.EventArgs derived object that contains the
    '						following members:
    '
    '						Count       Number of items in the Tags array.
    '						Tags        Array of items to read.
    '						AccessPaths Array of requested access paths.
    '									Note: This server does not support access paths.
    ' 						Errors		Array of item-level error codes.
    '							sdaSOK -	The corresponding tag was read 
    '										successfully. That tags value, 
    '										quality, and timestamp was updated.
    '							sdaEFail -	The read operation for the corresponding 
    '										tag failed.
    '						Result		 The overall result of the operation.
    '							sdaSOK	-	All tags were read successfully. Each 
    '										tags value, quality, and timestamp 
    '										was updated. All entries in the Errors 
    '										array are sdaSOK.
    '							sdaSFalse -	The operation succeeded, but one or 
    '										more elements in the Errors array 
    '										contains an error value.
    '							sdaEFail -	The operation as a whole failed.
    '	Out:	None
    '
    '	Return Values:	None
    '********************************************************************************
    Private Sub SlikServer1_OnRead( _
        ByVal sender As System.Object, _
        ByVal eventArgs As SLIKDA.SLIKServer.OnReadEventArgs _
    ) Handles SlikServer1.OnRead

        On Error GoTo errHandler

        Call ReadTags(eventArgs.Count, eventArgs.Tags, eventArgs.Errors, eventArgs.Result)
        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "OnRead Event Error")
        eventArgs.Result = SLIKDA.OPCDAErrorsEnum.sdaEFail

    End Sub

    '********************************************************************************
    ' Description:	This event is fired whenever an OPC client has issued a 
    '				request to write new values to one or more tags.
    '
    '				NOTE: A handler should always be provided for this event!
    '
    ' Parameters:
    '   In:	sender	-	the SLIKServer object that fired the event
    '			eventArgs -	an System.EventArgs derived object that contains the
    '						following members:
    '
    '						Count       Number of items in the Tags array.
    '						Tags        Array of items to write.
    '						AccessPaths Array of requested access paths.
    '									Note: This server does not support access paths.
    '						Values      Array of values to be written to each item.
    '						Errors      Array of item-level return codes. Possible values
    '									for each element include:
    '							sdaSOK -	The corresponding tag was written successfully.
    '										That tags value, quality, and timestamp 
    '										was updated.
    '							sdaSClamp -	The corresponding tag was written 
    '										successfully, but was clamped.
    '							sdaERange -	The value was out of range. It was 
    '										not written to the tag.
    '							sdaEFail -	The write operation for the corresponding 
    '										tag failed.
    '						Result		 The overall result of the operation.
    '							sdaSOK -	All tags were written successfully. Each 
    '										tags value, quality, and timestamp was 
    '										updated. All entries in the Errors array 
    '										are sdaSOK.
    '							sdaSFalse -	The operation succeeded, but one or more 
    '										elements in the Errors array contains an 
    '										error value.
    '							sdaEFail -	The operation as a whole failed.
    '
    '	Out:	None
    '
    '	Return Values:	None
    '********************************************************************************
    Private Sub SlikServer1_OnWrite( _
        ByVal sender As System.Object, _
        ByVal eventArgs As SLIKDA.SLIKServer.OnWriteEventArgs _
    ) Handles SlikServer1.OnWrite
        On Error GoTo errHandler

        Dim Qualities() As Short = {}
        Dim Timestamps() As System.DateTime = {}
        Call WriteTags( _
            eventArgs.Count, _
            eventArgs.Tags, _
            eventArgs.Values, _
            Qualities, _
            Timestamps, _
            eventArgs.Errors, _
            eventArgs.Result _
            )
        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "OnWrite Event Error")
        eventArgs.Result = SLIKDA.OPCDAErrorsEnum.sdaEFail

    End Sub

    '********************************************************************************
    ' Description:	This event is fired whenever an OPC client has issued a 
    '				request to write new values to one or more tags.
    '
    '				NOTE: A handler should always be provided for this event!
    '
    ' Parameters:
    '   In:	sender	-	the SLIKServer object that fired the event
    '			eventArgs -	an System.EventArgs derived object that contains the
    '						following members:
    '
    '						Count       Number of items in the Tags array.
    '						Tags        Array of tags to write.
    '						AccessPaths Array of requested access paths.
    '									Note: This server does not support access paths.
    '                       Values      Array of values to be written. If an
    '                                   entry contains an empty variant then a value is
    '                                   not to be written to the corresponding tag.
    '                       Qualities   Array of qualities to be written. If an
    '                                   entry contains -1 then the quality is
    '                                   not to be written to the corresponding tag.
    '                       Timestamps  Array of timestamps to be written. If an
    '                                   entry contains a 0 then a timestamp is
    '                                   not to be written to the corresponding tag.
    '						Errors      Array of item-level return codes. Possible values
    '									for each element include:
    '							sdaSOK -	The corresponding tag was written successfully.
    '										That tags value, quality, and timestamp 
    '										was updated.
    '							sdaSClamp -	The corresponding tag was written 
    '										successfully, but was clamped.
    '							sdaERange -	The value was out of range. It was 
    '										not written to the tag.
    '							sdaEFail -	The write operation for the corresponding 
    '										tag failed.
    '						Result		 The overall result of the operation.
    '							sdaSOK -	All tags were written successfully. Each 
    '										tags value, quality, and timestamp was 
    '										updated. All entries in the Errors array 
    '										are sdaSOK.
    '							sdaSFalse -	The operation succeeded, but one or more 
    '										elements in the Errors array contains an 
    '										error value.
    '							sdaEFail -	The operation as a whole failed.
    '
    '	Out:	None
    '
    '	Return Values:	None
    '********************************************************************************
    Private Sub SlikServer1_OnWriteVQT( _
        ByVal sender As System.Object, _
        ByVal eventArgs As SLIKDA.SLIKServer.OnWriteVQTEventArgs _
    ) Handles SlikServer1.OnWriteVQT
        On Error GoTo errHandler

        Call WriteTags( _
            eventArgs.Count, _
            eventArgs.Tags, _
            eventArgs.Values, _
            eventArgs.Qualities, _
            eventArgs.Timestamps, _
            eventArgs.Errors, _
            eventArgs.Result _
            )
        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "OnWriteVQT Event Error")
        eventArgs.Result = SLIKDA.OPCDAErrorsEnum.sdaEFail

    End Sub

    '********************************************************************************
    ' Description:	This event is fired when SLIK-DA is outputting a trace
    '				message, if and only if the trace destination was set to
    '				sdaTraceToEvent via the SetTraceInfo() method.
    '
    ' Parameters:
    '   In:	    sender	-	the SLIKServer object that fired the event
    '			eventArgs -	an System.EventArgs derived object that contains the
    '						following members:
    '
    '   						TraceMessage	The trace message string.
    '
    '   Out:    None
    '
    ' Return Value:     None
    '********************************************************************************
    Private Sub SlikServer1_OnTrace( _
        ByVal sender As System.Object, _
        ByVal eventArgs As SLIKDA.SLIKServer.OnTraceEventArgs _
    ) Handles SlikServer1.OnTrace
        ' Remove the trailing newline character
        eventArgs.TraceMessage = Mid(eventArgs.TraceMessage, 1, Len(eventArgs.TraceMessage) - 1)

        Call LogTraceMessage(eventArgs.TraceMessage)

    End Sub

    '********************************************************************************
    ' Description:	This event is fired when OPC private security is enabled
    '               and a client is attempting to logon.
    '
    ' Parameters:
    '   In:	    sender	-	the SLIKServer object that fired the event
    '			eventArgs -	an System.EventArgs derived object that contains the
    '						following members:
    '
    '   					UserName	[in] The user to logon.
    '                       Password    [in] The user's password.
    '                       UserSID     [out] A unique security identifier for this user
    '                       Result      [out] The result of the operation.  Should 
    '                                   be one of sdaSOK, sdaAccessDenied, sdaEFail
    '
    '   Out:    None
    '
    ' Return Value:     None
    '********************************************************************************
    Private Sub SlikServer1_OnAuthenticate( _
        ByVal sender As Object, _
        ByVal eventArgs As SLIKDA.SLIKServer.OnAuthenticateEventArgs _
    ) Handles SlikServer1.OnAuthenticate

        On Error GoTo errHandler

        eventArgs.Result = SLIKDA.OPCDAErrorsEnum.sdaEAccessDenied
        Dim i As Integer
        For i = 0 To 2
            If (eventArgs.UserName = m_SecDB(i).UserName) And (eventArgs.Password = m_SecDB(i).Password) Then
                ' In this example the user security identifier is simply
                ' the index into the security database
                eventArgs.UserSID = i
                eventArgs.Result = SLIKDA.OPCDAErrorsEnum.sdaSOK
                Exit For
            End If
        Next i

        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "OnAuthenticate Event Error")
        eventArgs.Result = SLIKDA.OPCDAErrorsEnum.sdaEFail

    End Sub

    '********************************************************************************
    ' Description:	This event is fired when OPC private security is enabled
    '               and a client is attempting to logon.
    '
    ' Parameters:
    '   In:	    sender	-	the SLIKServer object that fired the event
    '			eventArgs -	an System.EventArgs derived object that contains the
    '						following members:
    '
    '   					UserSID 	    [in] User security identifier.
    '                       TagName         [in] Tag name to access check, or an empty
    '                                       string if security granularity is "server".
    '                       AccessGranted   [out] The access rights granted to the user.
    '                                       Should be a combination of the values defined
    '                                       by the AccessGranted enumeration.
    '                       Result          [out] The result of the operation.  Should 
    '                                       be one of sdaSOK, sdaEInvalidArg, sdaEFail
    '
    '   Out:    None
    '
    ' Return Value:     None
    '********************************************************************************
    Private Sub SlikServer1_OnAccessCheck( _
        ByVal sender As Object, _
        ByVal eventArgs As SLIKDA.SLIKServer.OnAccessCheckEventArgs _
    ) Handles SlikServer1.OnAccessCheck

        On Error GoTo errHandler

        '
        '   This example uses "server" level security granularity.  As such,
        '   the granted access permissions returned here will apply to all tags
        '   the user might access.
        '
        If (eventArgs.UserSID <= 2) Then
            eventArgs.AccessGranted = m_SecDB(eventArgs.UserSID).AccessGranted
            eventArgs.Result = SLIKDA.OPCDAErrorsEnum.sdaSOK
        Else
            eventArgs.Result = SLIKDA.OPCDAErrorsEnum.sdaEInvalidArg
        End If

        Exit Sub

errHandler:
        Call ReportEvent(Err.Description, "OnAccessCheck Event Error")
        eventArgs.Result = SLIKDA.OPCDAErrorsEnum.sdaEFail

    End Sub

    '********************************************************************************
    ' Description:      Periodic timer to update the server statistics view.
    '
    ' Parameters:
    '   In:             None
    '
    '   Out:            None
    '
    ' Return Value:     None
    '********************************************************************************
    Private Sub tmrMain_Tick(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles tmrMain.Tick

        Call UpdateStatsView()

    End Sub

    '********************************************************************************
    ' Description:      Periodic timer to update the tags.
    '
    ' Parameters:
    '   In:             None
    '
    '   Out:            None
    '
    ' Return Value:     None
    '********************************************************************************
    Private Sub tmrTagUpdate_Tick(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles tmrTagUpdate.Tick

        If tmrTagUpdate.Enabled = False Then Exit Sub
        tmrTagUpdate.Enabled = False

        Call UpdateTags((SlikServer1.SLIKTags))

        tmrTagUpdate.Enabled = True

    End Sub
End Class